/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPAddress;
import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class ARPProcessEvent
extends IPCEvent {
    public EventType type;

    public ARPProcessEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ARP_ENTRY_ADDED,
        ARP_ENTRY_REMOVED,
        FOUND_TAKING_MY_IP,
        FOUND_MY_IP_TAKEN;

    }

    public static class FoundMyIpTaken
    extends ARPProcessEvent {
        public IPAddress ip;
        public MACAddress otherMac;
        public String portName;

        public FoundMyIpTaken(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FOUND_MY_IP_TAKEN;
            this.ip = (IPAddress)ltv.getEventParameters().get(0);
            this.otherMac = (MACAddress)ltv.getEventParameters().get(1);
            this.portName = (String)ltv.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tip = " + this.ip + "\n\totherMac = " + this.otherMac + "\n\tportName = " + this.portName;
        }
    }

    public static class FoundTakingMyIp
    extends ARPProcessEvent {
        public IPAddress ip;
        public MACAddress otherMac;
        public String portName;

        public FoundTakingMyIp(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FOUND_TAKING_MY_IP;
            this.ip = (IPAddress)ltv.getEventParameters().get(0);
            this.otherMac = (MACAddress)ltv.getEventParameters().get(1);
            this.portName = (String)ltv.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tip = " + this.ip + "\n\totherMac = " + this.otherMac + "\n\tportName = " + this.portName;
        }
    }

    public static class ArpEntryRemoved
    extends ARPProcessEvent {
        public IPAddress ip;
        public MACAddress mac;
        public String portName;

        public ArpEntryRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ARP_ENTRY_REMOVED;
            this.ip = (IPAddress)ltv.getEventParameters().get(0);
            this.mac = (MACAddress)ltv.getEventParameters().get(1);
            this.portName = (String)ltv.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tip = " + this.ip + "\n\tmac = " + this.mac + "\n\tportName = " + this.portName;
        }
    }

    public static class ArpEntryAdded
    extends ARPProcessEvent {
        public IPAddress ip;
        public MACAddress mac;
        public String portName;

        public ArpEntryAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ARP_ENTRY_ADDED;
            this.ip = (IPAddress)ltv.getEventParameters().get(0);
            this.mac = (MACAddress)ltv.getEventParameters().get(1);
            this.portName = (String)ltv.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tip = " + this.ip + "\n\tmac = " + this.mac + "\n\tportName = " + this.portName;
        }
    }
}

